#!/bin/bash

# Log file
LOGFILE="run-scripts.log"

# Function to log messages
log_message() {
    echo "$1" | tee -a "$LOGFILE"
}

log_message "--- Hanya butuh sekali eksekusi diawal saja ---"
log_message "--- Run using sudo bash ./run-scripts.sh ---"
log_message ""

# Check if the script is run as root
if [ "$(id -u)" -ne 0 ]; then
    log_message "Please run this script as root or using sudo!"
    exit 1
fi

run_script() {
    local script="$1"
    
    log_message "Menjalankan $script..."

    # Kondisi khusus untuk setup-network.sh yang membutuhkan inputan
    if [ "$script" == "setup-network.sh" ]; then
        # Mengirim input '1' untuk dua input ke setup-network.sh
        if (echo -e "1\n1" | sudo bash "./$script" >> "$LOGFILE" 2>&1); then
            log_message "$script berhasil dijalankan dengan input '1' dua kali."
        else
            log_message "$script gagal dijalankan."
            exit 1
        fi

    # Kondisi khusus untuk factory-clean.sh yang membutuhkan inputan 1-4 diikuti dengan 2
    elif [ "$script" == "factory-clean.sh" ]; then
        # Mengirim input '1' sebanyak 4 kali diikuti dengan '2'
        if (echo -e "1\n1\n1\n2" | sudo bash "./$script" >> "$LOGFILE" 2>&1); then
            log_message "$script berhasil dijalankan dengan input '1' empat kali diikuti dengan '2'."
        else
            log_message "$script gagal dijalankan."
            exit 1
        fi
    else
        # Menjalankan script lain tanpa input
        if sudo bash "./$script" >> "$LOGFILE" 2>&1; then
            log_message "$script berhasil dijalankan."
        else
            log_message "$script gagal dijalankan."
            exit 1
        fi
    fi
}





# Run the individual scripts
# run_script "install-first.sh"
run_script "adduser.sh"
run_script "rautologin.sh"
run_script "cpass.sh"
# run_script "setup-network.sh"

log_message "Semua script telah selesai dijalankan dengan sukses."
